<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequirementsTable extends Migration {

	public function up()
	{
		Schema::create('requirements', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('year', array('1397', '1398', '1399', '1400', '1401', '1402'))->unique();
			$table->double('financial_coverage')->nullable();
			$table->double('requirement_life');
			$table->double('requirement_driver');
			$table->tinyInteger('is_active')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('requirements');
	}
}