<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateThirdsTable extends Migration {

	public function up()
	{
		Schema::create('thirds', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('brand_id')->unsigned();
			$table->string('name')->nullable();
			$table->text('description')->nullable();
			$table->double('max_discount_percent')->nullable();
			$table->double('max_years_percent');
			$table->double('max_years_count')->nullable();
			$table->double('discount_manager_amount')->nullable();
			$table->double('discount_manager_percent')->nullable();
			$table->integer('installment')->nullable();
			$table->double('installment_percent')->nullable();
			$table->integer('short_term')->nullable();
			$table->double('shortterm_before')->nullable();
			$table->double('tax');
			$table->boolean('round_it')->default(1);
			$table->boolean('is_active')->default(1);
			$table->integer('position')->default('1000');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('thirds');
	}
}