<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserAddressesTable extends Migration {

	public function up()
	{
		Schema::create('user_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('name');
			$table->string('receiver_name')->nullable();
			$table->text('address')->nullable();
			$table->string('post_code')->nullable();
			$table->string('lat')->nullable();
			$table->string('lng')->nullable();
			$table->integer('province');
			$table->integer('city');
			$table->string('mobile');
			$table->string('phone')->nullable();
			$table->boolean('is_active')->default(1);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_addresses');
	}
}