<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('user_id');
			$table->string('full_name')->nullable()->index();
			$table->string('phone')->nullable();
			$table->integer('hospital_id')->unsigned();
			$table->string('medical_records')->nullable();
			$table->string('ktp')->nullable();
			$table->string('golongan_darah')->nullable();
			$table->text('alergi')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}