<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHospitalsTable extends Migration {

	public function up()
	{
		Schema::create('hospitals', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->text('address');
			$table->float('latitude')->nullable();
			$table->float('longitude')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('hospitals');
	}
}