<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSalePeriodsTable extends Migration {

	public function up()
	{
		Schema::create('sale_periods', function(Blueprint $table) {
			$table->increments('id');
			$table->datetime('begins_at')->nullable()->index();
			$table->datetime('expires_at')->nullable()->index();
			$table->integer('discount_amount')->unsigned()->nullable();
			$table->smallInteger('discount_percentage')->unsigned()->nullable();
			$table->integer('category_id')->unsigned()->nullable()->index();
			$table->integer('product_id')->unsigned()->nullable()->index();
			$table->string('product_type', 32)->index();
			$table->integer('product_partner_id')->unsigned()->nullable()->index();
			$table->string('coupon_code', 32)->unique()->nullable();
			$table->integer('minimum_spend')->unsigned()->nullable();
			$table->integer('max_spend')->unsigned()->nullable();
			$table->text('excluded_users')->nullable();
			$table->text('excluded_categories')->nullable();
			$table->text('excluded_products')->nullable();
			$table->smallInteger('max_uses')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sale_periods');
	}
}