<?php

namespace Dvlop;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AvailableDownload extends Eloquent {

	protected $table = 'available_downloads';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'product_type', 'product_id', 'item_order_id');

	public function orderItem()
	{
		return $this->belongsTo('OrderItem');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

}