<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDownloadsTable extends Migration {

	public function up()
	{
		Schema::create('downloads', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('product_type', 32);
			$table->integer('product_id')->nullable();
			$table->text('ip')->default('ip_address_should_have_a_field_type');
			$table->text('user_agent');
			$table->string('location')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('downloads');
	}
}