<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderItemsTable extends Migration {

	public function up()
	{
		Schema::create('order_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('item_type', 32)->nullable()->index();
			$table->integer('item_id')->unsigned()->nullable()->index();
			$table->integer('purchase_price')->unsigned()->nullable();
			$table->integer('sale_period_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('order_items');
	}
}