<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentMethodsTable extends Migration {

	public function up()
	{
		Schema::create('payment_methods', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->string('provider', 32)->default('braintree');
			$table->string('type', 32)->index();
			$table->string('external_id')->unique()->nullable();
			$table->string('country_code', 3)->nullable()->index();
			$table->string('exp_month', 2)->nullable();
			$table->string('exp_year', 4)->nullable();
			$table->string('last4', 4)->nullable();
			$table->text('meta')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('payment_methods');
	}
}