<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('slug', 32)->unique();
			$table->string('name');
			$table->text('content')->nullable();
			$table->text('excerpt')->nullable();
			$table->datetime('published_at')->nullable()->index();
			$table->boolean('members_only')->unique()->default(false);
			$table->integer('author_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}