<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('product_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->unique();
			$table->string('slug', 32)->unique();
			$table->timestamps();
			$table->softDeletes();
			$table->integer('parent_id')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('product_categories');
	}
}