<?php

namespace Dvlop;

class OrderItem extends Eloquent {

	protected $table = 'order_items';
	public $timestamps = true;
	protected $fillable = array('item_type', 'item_id', 'purchase_price');

	public function order()
	{
		return $this->belongsTo('Order');
	}

	public function user()
	{
		return $this->hasManyThrough('ProductPartner', 'Order');
	}

	public function item()
	{
		return $this->morphTo();
	}

}