<?php

namespace Dvlop;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductPartner extends Eloquent {

	protected $table = 'product_partners';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'slug', 'website');

	public function users()
	{
		return $this->belongsToMany('User');
	}

	public function commissions()
	{
		return $this->hasMany('Commission');
	}

	public function presets()
	{
		return $this->belongsToMany('Preset');
	}

	public function commissionRates()
	{
		return $this->hasManyThrough('CommissionRate', 'Preset');
	}

	public function presets()
	{
		return $this->belongsToMany('Preset');
	}

}