<?php

namespace Dvlop;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CommissionRate extends Eloquent {

	protected $table = 'commission_rates';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('product_partner_id', 'product_id', 'product_type', 'commission_percentage', 'begins_at', 'expires_at');

	public function preset()
	{
		return $this->belongsTo('Preset');
	}

	public function commissions()
	{
		return $this->hasMany('Commission');
	}

	public function photographyStudio()
	{
		return $this->belongsTo('ProductPartner');
	}

}