<?php

namespace Dvlop;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PaymentMethod extends Eloquent {

	protected $table = 'payment_methods';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'provider', 'type', 'external_id', 'country_code', 'exp_month', 'exp_year', 'last4', 'meta');

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function orders()
	{
		return $this->hasMany('Order');
	}

}