<?php

namespace Dvlop;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'name', 'content', 'excerpt', 'published_at', 'members_only', 'author_id');

	public function tags()
	{
		return $this->morphToMany('Tag');
	}

	public function author()
	{
		return $this->hasOne('User');
	}

}