<?php

namespace Dvlop;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Preset extends Eloquent {

	protected $table = 'presets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'price', 'launch_date', 'member_only');

	public function commissions()
	{
		return $this->hasMany('Commission');
	}

	public function orders()
	{
		return $this->hasMany('Order');
	}

	public function categories()
	{
		return $this->belongsToMany('PresetCategory');
	}

	public function tags()
	{
		return $this->morphToMany('Tag');
	}

}