<?php

namespace Dvlop;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PresetCategory extends Eloquent {

	protected $table = 'product_categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'slug');

	public function presets()
	{
		return $this->belongsToMany('ProductPartner');
	}

	public function dynamicPricings()
	{
		return $this->hasMany('DynamicPricing');
	}

	public function salePeriods()
	{
		return $this->hasMany('SalePeriod');
	}

}