<?php

namespace Dvlop;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('first_name', 'last_name', 'email', 'username', 'password', 'address_street_1', 'address_street_2', 'address_city', 'address_state_province', 'address_postal_code', 'address_country_code', 'phone_number');
	protected $hidden = array('password', 'rememberToken');

	public function photographyStudios()
	{
		return $this->belongsToMany('ProductPartner');
	}

	public function orders()
	{
		return $this->hasMany('Order');
	}

	public function orderedItems()
	{
		return $this->hasManyThrough('OrderItem', 'Order');
	}

	public function commisions()
	{
		return $this->hasManyThrough('Commission', 'PhotographyStudio');
	}

	public function paymentMethods()
	{
		return $this->hasMany('PaymentMethod');
	}

	public function memberships()
	{
		return $this->hasMany('Membership');
	}

	public function posts()
	{
		return $this->hasMany('Post');
	}

}