<?php

namespace Dvlop;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CommissionRate extends Model 
{

    protected $table = 'commission_rates';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('product_partner_id', 'product_id', 'product_type', 'commission_percentage', 'begins_at', 'expires_at');

    public function preset()
    {
        return $this->belongsTo('Preset');
    }

    public function commissions()
    {
        return $this->hasMany('Commission');
    }

    public function photographyStudio()
    {
        return $this->belongsTo('ProductPartner');
    }

}