<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommissionRatesTable extends Migration {

	public function up()
	{
		Schema::create('commission_rates', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_partner_id')->unsigned()->index();
			$table->integer('product_id')->unsigned()->index();
			$table->string('product_type', 32)->index();
			$table->smallInteger('commission_percentage');
			$table->datetime('begins_at')->index();
			$table->datetime('expires_at')->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('commission_rates');
	}
}