<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePresetsTable extends Migration {

	public function up()
	{
		Schema::create('presets', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->unique();
			$table->integer('price')->unsigned();
			$table->date('launch_date');
			$table->boolean('member_only')->index()->default(false);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('presets');
	}
}