<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('payment_methods', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('payment_method_id')->references('id')->on('payment_methods')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('sale_periods', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('product_categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('sale_periods', function(Blueprint $table) {
			$table->foreign('product_partner_id')->references('id')->on('product_partners')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->foreign('order_item_id')->references('id')->on('order_items')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->foreign('product_partner_id')->references('id')->on('product_partners')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->foreign('commission_rate_id')->references('id')->on('commission_rates')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('commission_rates', function(Blueprint $table) {
			$table->foreign('product_partner_id')->references('id')->on('product_partners')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('product_categories')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('dynamic_pricing', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('product_categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('memberships', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('memberships', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('galleries', function(Blueprint $table) {
			$table->foreign('product_partner_id')->references('id')->on('product_partners')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('galleries', function(Blueprint $table) {
			$table->foreign('preset_id')->references('id')->on('presets')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('gallery_images', function(Blueprint $table) {
			$table->foreign('gallery_id')->references('id')->on('galleries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('sale_period_id')->references('id')->on('sale_periods')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('available_downloads', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('available_downloads', function(Blueprint $table) {
			$table->foreign('item_order_id')->references('id')->on('order_items')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('downloads', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('available_downloads')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_author_id_foreign');
		});
		Schema::table('payment_methods', function(Blueprint $table) {
			$table->dropForeign('payment_methods_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_payment_method_id_foreign');
		});
		Schema::table('sale_periods', function(Blueprint $table) {
			$table->dropForeign('sale_periods_category_id_foreign');
		});
		Schema::table('sale_periods', function(Blueprint $table) {
			$table->dropForeign('sale_periods_product_partner_id_foreign');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->dropForeign('commissions_order_id_foreign');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->dropForeign('commissions_order_item_id_foreign');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->dropForeign('commissions_product_partner_id_foreign');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->dropForeign('commissions_commission_rate_id_foreign');
		});
		Schema::table('commission_rates', function(Blueprint $table) {
			$table->dropForeign('commission_rates_product_partner_id_foreign');
		});
		Schema::table('product_categories', function(Blueprint $table) {
			$table->dropForeign('product_categories_parent_id_foreign');
		});
		Schema::table('dynamic_pricing', function(Blueprint $table) {
			$table->dropForeign('dynamic_pricing_category_id_foreign');
		});
		Schema::table('memberships', function(Blueprint $table) {
			$table->dropForeign('memberships_order_id_foreign');
		});
		Schema::table('memberships', function(Blueprint $table) {
			$table->dropForeign('memberships_user_id_foreign');
		});
		Schema::table('galleries', function(Blueprint $table) {
			$table->dropForeign('galleries_product_partner_id_foreign');
		});
		Schema::table('galleries', function(Blueprint $table) {
			$table->dropForeign('galleries_preset_id_foreign');
		});
		Schema::table('gallery_images', function(Blueprint $table) {
			$table->dropForeign('gallery_images_gallery_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_sale_period_id_foreign');
		});
		Schema::table('available_downloads', function(Blueprint $table) {
			$table->dropForeign('available_downloads_user_id_foreign');
		});
		Schema::table('available_downloads', function(Blueprint $table) {
			$table->dropForeign('available_downloads_item_order_id_foreign');
		});
		Schema::table('downloads', function(Blueprint $table) {
			$table->dropForeign('downloads_user_id_foreign');
		});
	}
}