<?php

namespace Dvlop;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;
	protected $fillable = array('user_id', 'xero_id', 'payment_method_id', 'meta', 'subtotal', 'total');

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function paymentMethod()
	{
		return $this->belongsTo('PaymentMethod');
	}

	public function orderedItems()
	{
		return $this->hasMany('OrderItem');
	}

}