<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('email');

    public function profile()
    {
        return $this->hasOne('UserProfile', 'id');
    }

    public function groups()
    {
        return $this->belongsToMany('UserGroup');
    }

    public function client()
    {
        return $this->belongsTo('Client');
    }

    public function login_attempts()
    {
        return $this->hasMany('LoginAttempt');
    }

    public function notification_prefs()
    {
        return $this->hasMany('UserNotificationPref');
    }

    public function singleSignOn()
    {
        return $this->hasOne('SingleSignOn', 'id', 'user_id');
    }

}