<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->string('number')->unique()->default('14-00-00-01');
			$table->integer('creator')->unsigned();
			$table->integer('client_id')->unsigned();
			$table->string('name');
			$table->text('description');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}