<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCasesTable extends Migration {

	public function up()
	{
		Schema::create('cases', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('number', 255);
			$table->integer('customer_id')->unsigned()->nullable();
			$table->integer('court_id')->unsigned()->nullable();
			$table->tinyInteger('is_legal_aid')->default('0');
			$table->integer('lawyer_employee_id')->unsigned();
			$table->integer('case_status_id')->unsigned();
			$table->datetime('closed_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('cases');
	}
}