<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotesTable extends Migration {

	public function up()
	{
		Schema::create('notes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('note_type_id')->unsigned()->nullable();
			$table->string('title', 1024)->nullable();
			$table->longText('note')->nullable();
			$table->integer('case_id')->unsigned()->nullable();
			$table->integer('customer_id')->unsigned()->nullable();
			$table->integer('employee_id')->unsigned()->nullable();
			$table->integer('professional_ressource_id')->unsigned()->nullable();
			$table->string('author_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('notes');
	}
}