<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('persons')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('main_address')->references('id')->on('addresses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cases', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cases', function(Blueprint $table) {
			$table->foreign('court_id')->references('id')->on('courts')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cases', function(Blueprint $table) {
			$table->foreign('lawyer_employee_id')->references('id')->on('employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cases', function(Blueprint $table) {
			$table->foreign('case_status_id')->references('id')->on('case_status')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('persons')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('phone_number')->references('id')->on('phone_numbers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('cases')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('professional_ressource_id')->references('id')->on('professional_ressources')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('event_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('professional_ressources', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('persons')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('professional_ressources', function(Blueprint $table) {
			$table->foreign('address')->references('id')->on('addresses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('professional_ressources', function(Blueprint $table) {
			$table->foreign('ressource_type_id')->references('id')->on('ressource_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('professional_ressources', function(Blueprint $table) {
			$table->foreign('professional_type_id')->references('id')->on('professional_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('courts', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('addresses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('courts', function(Blueprint $table) {
			$table->foreign('phone')->references('id')->on('phone_numbers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('courts', function(Blueprint $table) {
			$table->foreign('fax')->references('id')->on('phone_numbers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('note_type_id')->references('id')->on('note_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('cases')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('professional_ressource_id')->references('id')->on('professional_ressources')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('cases_professional_ressources', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('cases')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cases_professional_ressources', function(Blueprint $table) {
			$table->foreign('professional_ressource_id')->references('id')->on('professional_ressources')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cases_charges', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('cases')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cases_charges', function(Blueprint $table) {
			$table->foreign('charge_id')->references('id')->on('charges')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('phone_numbers', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('phone_numbers', function(Blueprint $table) {
			$table->foreign('professional_ressource_id')->references('id')->on('professional_ressources')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('phone_numbers', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('cases')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_employee_id_foreign');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_person_id_foreign');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_main_address_foreign');
		});
		Schema::table('cases', function(Blueprint $table) {
			$table->dropForeign('cases_customer_id_foreign');
		});
		Schema::table('cases', function(Blueprint $table) {
			$table->dropForeign('cases_court_id_foreign');
		});
		Schema::table('cases', function(Blueprint $table) {
			$table->dropForeign('cases_lawyer_employee_id_foreign');
		});
		Schema::table('cases', function(Blueprint $table) {
			$table->dropForeign('cases_case_status_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_person_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_phone_number_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_case_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_customer_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_professional_ressource_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_employee_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_type_id_foreign');
		});
		Schema::table('professional_ressources', function(Blueprint $table) {
			$table->dropForeign('professional_ressources_person_id_foreign');
		});
		Schema::table('professional_ressources', function(Blueprint $table) {
			$table->dropForeign('professional_ressources_address_foreign');
		});
		Schema::table('professional_ressources', function(Blueprint $table) {
			$table->dropForeign('professional_ressources_ressource_type_id_foreign');
		});
		Schema::table('professional_ressources', function(Blueprint $table) {
			$table->dropForeign('professional_ressources_professional_type_id_foreign');
		});
		Schema::table('courts', function(Blueprint $table) {
			$table->dropForeign('courts_address_id_foreign');
		});
		Schema::table('courts', function(Blueprint $table) {
			$table->dropForeign('courts_phone_foreign');
		});
		Schema::table('courts', function(Blueprint $table) {
			$table->dropForeign('courts_fax_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_note_type_id_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_case_id_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_customer_id_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_employee_id_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_professional_ressource_id_foreign');
		});
		Schema::table('cases_professional_ressources', function(Blueprint $table) {
			$table->dropForeign('cases_professional_ressources_case_id_foreign');
		});
		Schema::table('cases_professional_ressources', function(Blueprint $table) {
			$table->dropForeign('cases_professional_ressources_professional_ressource_id_foreign');
		});
		Schema::table('cases_charges', function(Blueprint $table) {
			$table->dropForeign('cases_charges_case_id_foreign');
		});
		Schema::table('cases_charges', function(Blueprint $table) {
			$table->dropForeign('cases_charges_charge_id_foreign');
		});
		Schema::table('phone_numbers', function(Blueprint $table) {
			$table->dropForeign('phone_numbers_customer_id_foreign');
		});
		Schema::table('phone_numbers', function(Blueprint $table) {
			$table->dropForeign('phone_numbers_professional_ressource_id_foreign');
		});
		Schema::table('phone_numbers', function(Blueprint $table) {
			$table->dropForeign('phone_numbers_employee_id_foreign');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->dropForeign('documents_case_id_foreign');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->dropForeign('documents_customer_id_foreign');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->dropForeign('documents_employee_id_foreign');
		});
	}
}