<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Cases extends Eloquent {

	protected $table = 'cases';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function charges()
	{
		return $this->hasMany('Cases_charges', 'case_id');
	}

	public function court()
	{
		return $this->hasOne('Courts', 'court_id');
	}

	public function lawyer()
	{
		return $this->hasOne('Employees', 'lawyer_employee_id');
	}

	public function professional_ressources()
	{
		return $this->hasMany('Cases_professional_ressources', 'case_id');
	}

	public function events()
	{
		return $this->hasMany('Events', 'case_id');
	}

	public function customer()
	{
		return $this->hasOne('Customers', 'customer_id');
	}

	public function notes()
	{
		return $this->hasMany('Notes', 'case_id');
	}

	public function case_progression()
	{
		return $this->hasOne('Case_status', 'case_progression_id');
	}

}