<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Customers extends Eloquent {

	protected $table = 'customers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function phones()
	{
		return $this->hasMany('Phone_numbers', 'customer_id');
	}

	public function main_address()
	{
		return $this->hasOne('Addresses', 'main_address');
	}

	public function person()
	{
		return $this->hasOne('Persons');
	}

}