<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function site()
	{
		return $this->hasOne('Site');
	}

	public function type()
	{
		return $this->hasOne('Type');
	}

	public function content()
	{
		return $this->hasOne('Content');
	}

	public function resource()
	{
		return $this->hasMany('Resources');
	}

}