<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Type extends Eloquent {

	protected $table = 'types';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function posts()
	{
		return $this->hasMany('Post');
	}

	public function category()
	{
		return $this->belongsTo('Category');
	}

	public function types()
	{
		return $this->belongsToMany('Site_type');
	}

}