<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('site_id')->unsigned();
			$table->integer('content_id')->unsigned()->nullable();
			$table->integer('user_id')->unsigned();
			$table->integer('type_id')->unsigned();
			$table->integer('category_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}