<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Site extends Eloquent {

	protected $table = 'sites';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function socialMedia()
	{
		return $this->hasMany('Socialaccount');
	}

	public function posts()
	{
		return $this->hasMany('Post');
	}

	public function usersites()
	{
		return $this->hasMany('Siteuser');
	}

	public function site_cat()
	{
		return $this->hasMany('Category_site');
	}

	public function site_type()
	{
		return $this->hasMany('Site_type');
	}

}