<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContentsTable extends Migration {

	public function up()
	{
		Schema::create('contents', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('post_id')->unsigned();
			$table->string('title');
			$table->string('contents');
			$table->string('Venue');
			$table->date('start_date')->nullable();
			$table->time('start_time')->nullable();
			$table->date('end_date')->nullable();
			$table->time('end_time')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('contents');
	}
}