<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductosTable extends Migration {

	public function up()
	{
		Schema::create('productos', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_producto_canonical');
			$table->integer('id_marca')->unsigned();
			$table->integer('id_proveedor');
			$table->integer('id_cat_principal');
			$table->smallInteger('orden');
			$table->string('nombre', 255)->nullable();
			$table->string('referencia');
			$table->string('referencia_proveedor');
			$table->decimal('largo');
			$table->decimal('alto');
			$table->decimal('ancho');
			$table->decimal('diametro');
			$table->decimal('peso_neto');
			$table->decimal('peso_bruto');
			$table->integer('descatalogado');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('productos');
	}
}