<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeeTable extends Migration {

	public function up()
	{
		Schema::create('employee', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('offices_id')->unsigned();
			$table->integer('department_id_fk')->unsigned();
			$table->integer('group_id')->unsigned();
			$table->string('full_name', 200);
			$table->integer('national_identity');
			$table->enum('Job_title', array(''));
			$table->integer('mobile');
			$table->enum('status', array(''));
			$table->timestamps();
			$table->binary('photo');
		});
	}

	public function down()
	{
		Schema::drop('employee');
	}
}