<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGradesCoursesTable extends Migration {

	public function up()
	{
		Schema::create('grades_courses', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('academic_year', array('1438', '1439', '1440'));
			$table->integer('grades_id_fk')->unsigned();
			$table->integer('courses_id_fk')->unsigned();
			$table->enum('levels', array('level1', 'level2'));
			$table->enum('semesters', array('semester1', 'semester2', 'summer'));
			$table->string('description', 500);
			$table->integer('weekly_lessons');
			$table->integer('min_mark');
			$table->integer('max_mark');
		});
	}

	public function down()
	{
		Schema::drop('grades_courses');
	}
}