<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('translations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('locale');
			$table->string('group');
			$table->string('name');
			$table->text('value')->nullable();
			$table->datetime('viewed_at');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('translations');
	}
}