<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForecastsTable extends Migration {

	public function up()
	{
		Schema::create('forecasts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->float('amount');
			$table->float('factor', 10,6);
			$table->text('description');
			$table->integer('status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('forecasts');
	}
}