<?php

class Betline extends Eloquent {

	protected $table = 'betlines';
	public $timestamps = false;
	protected $fillable = array('bk_id', 'event_class_id', 'event_group_id', 'event_id', 'bet_id', 'outcome_id', 'status_id', 'passage_id', 'outcome_factor');
	protected $visible = array('bk_id', 'event_class_id', 'event_group_id', 'event_id', 'bet_id', 'outcome_id', 'status_id', 'passage_id', 'outcome_factor');

	public function bookmaker()
	{
		return $this->hasOne('Bookmaker', 'id', 'bk_id');
	}

	public function eventClass()
	{
		return $this->hasOne('BetlineEventClass', 'id', 'event_class_id');
	}

	public function eventGroup()
	{
		return $this->hasOne('BetlineEventGroup', 'id', 'event_group_id');
	}

	public function event()
	{
		return $this->hasOne('BetlineEvent', 'id', 'event_id');
	}

	public function bet()
	{
		return $this->hasOne('BetlineBet', 'id', 'bet_id');
	}

	public function outcome()
	{
		return $this->hasOne('BetlineOutcome', 'id', 'outcome_id');
	}

	public function status()
	{
		return $this->hasOne('BetlineStatus', 'id', 'status_id');
	}

	public function passage()
	{
		return $this->hasOne('BetlinePassage', 'id', 'passage_id');
	}

	public function country()
	{
		return $this->hasOne('BetlineCountry', 'id', 'event_class_id');
	}

}