<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerchantsTable extends Migration {

	public function up()
	{
		Schema::create('merchants', function(Blueprint $table) {
			$table->timestamps();
			$table->increments('id');
			$table->string('name', 200);
			$table->string('email', 100);
			$table->string('password', 50);
			$table->string('customer_service_number', 20);
			$table->string('specialization', 100);
			$table->string('expected_requests', 100);
			$table->integer('governorate_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->string('address', 200);
			$table->string('logo', 100);
			$table->string('commercial_license', 100);
		});
	}

	public function down()
	{
		Schema::drop('merchants');
	}
}