<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('contract_id')->unsigned();
			$table->bigInteger('payment_type_id')->unsigned();
			$table->bigInteger('payment_method_id')->unsigned();
			$table->enum('status', array('pending', 'paid', 'waiting'));
			$table->date('date');
			$table->date('due_date');
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}