<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCowsTable extends Migration {

	public function up()
	{
		Schema::create('cows', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('farm_id');
			$table->string('cow_no')->index();
			$table->string('cow_rfid');
			$table->string('name')->index();
			$table->integer('breed_id');
			$table->date('birth_date');
			$table->string('cow_father_no');
			$table->string('cow_mother_no');
			$table->string('cow_district');
			$table->json('picture');
			$table->string('cow_status');
			$table->timestamps();
			$table->string('previous_reg_no');
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('cows');
	}
}