<?php

namespace users;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Users extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function farms()
	{
		return $this->hasOne('Farm', 'farm_id');
	}

	public function cow()
	{
		return $this->hasMany('Cow', 'cow_id');
	}

}