<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned()->index();
			$table->bigInteger('contact_id')->index();
			$table->timestamps();
			$table->bigInteger('project_id')->unsigned()->index();
			$table->bigInteger('account_id')->unsigned();
			$table->string('indicator', 191)->nullable();
			$table->timestamp('invoice_date');
			$table->boolean('tax_value_added');
			$table->enum('sale_conditions', array('cash', 'credit'));
			$table->enum('type', array('sale', 'buy'));
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}