<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateObligationsTable extends Migration {

	public function up()
	{
		Schema::create('obligations', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('invoice_id')->unsigned()->index();
			$table->bigInteger('accounting_subject_id')->unsigned();
			$table->bigInteger('contact_id')->unsigned();
			$table->timestamp('obligations_date');
			$table->decimal('forecast_amount', 12,0);
			$table->text('description')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('obligations');
	}
}