<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_product', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('obligations', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('obligations', function(Blueprint $table) {
			$table->foreign('accounting_subject_id')->references('id')->on('accountin_subject')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('obligations', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_user_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_account_id_foreign');
		});
		Schema::table('invoice_product', function(Blueprint $table) {
			$table->dropForeign('invoice_product_invoice_id_foreign');
		});
		Schema::table('invoice_product', function(Blueprint $table) {
			$table->dropForeign('invoice_product_product_id_foreign');
		});
		Schema::table('obligations', function(Blueprint $table) {
			$table->dropForeign('obligations_invoice_id_foreign');
		});
		Schema::table('obligations', function(Blueprint $table) {
			$table->dropForeign('obligations_accounting_subject_id_foreign');
		});
		Schema::table('obligations', function(Blueprint $table) {
			$table->dropForeign('obligations_contact_id_foreign');
		});
	}
}